#!/usr/local/bin/ruby

if ARGV[0] == nil
  ARGV.push(".")
end

def lsdir(path)
  printf("Files in %s:\n", path)
  dirs=[]
  for f in Dir.entries(path)[2..-1].sort
    if test(?d, path+"/"+f)
      dirs << f
      f.concat("/")
    end
    printf("%s\n", f)
  end
  for d in dirs
    lsdir(path+"/"+d)
  end
end


for dir in ARGV
  lsdir(dir)
end
