#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <pwd.h>
#include <unistd.h>
#include "md5.h"
#include "base64.h"


#ifndef	_PASSWORD_LEN
#define	_PASSWORD_LEN	128
#endif
#define L	(_PASSWORD_LEN+256)
int main(int argc, char *argv[])
{
  char *digest;
  char d_str[L];
  char b6[L*2];
  char *pw, *p;
  memset(b6, 0, sizeof b6);
  if (argc != 3) {
    printf("Usage: ht UserName ChallengeInBase64\n");
    exit(1);
  }
  pw = getpass("SMTP-AUTH Password: ");
  b64_pton(argv[2], (u_char*)b6, L*2);

  //fprintf(stderr, "b6=[%s](%d), pw=[%s](%d)\n", b6, strlen(b6), pw, strlen(pw));
  digest = hmac_md5(b6, strlen(b6), pw, strlen(pw));
  snprintf(d_str, sizeof d_str, "%s ", argv[1]);
  p = d_str+strlen(d_str);
  sprintf(p, "%s", digest);
  printf("%s\n", d_str);
  b64_ntop((u_char*)d_str, strlen(d_str), b6, L*2);
  printf("%s\n", b6);
  memset(pw, 0, strlen(pw));
  return 0;
}
