/*
 *	progname.c - get program-name
 *
 *		Synopsis: char *_getprogname(char *arg0, char *defname)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"

#ifndef __MSDOS__
#define PROGNAMELEN		8
#else
#define PROGNAMELEN		128
#endif


char *_getprogname(char *arg0, char *defname)
{
	int len;
	register char *base;
	static char progname[PROGNAMELEN + 1];

#ifndef __MSDOS__
	if (0) {}
#else
	if (_osmajor < 3)
		len = strlen(base = defname);
#endif
	else {
		base = arg0;
		while (*arg0) {
			if (*arg0 == ':' || *arg0 == '\\' || *arg0 == '/')
				base = arg0 + 1;
			++arg0;
		}
		arg0 = base;
		while (*arg0) {
			if (*arg0 == '.')
				break;
			++arg0;
		}
		len = arg0 - base;
	}
	if (len > PROGNAMELEN)
		len = PROGNAMELEN;
	strncpy(progname, base, len);
	progname[len] = EOS;

#ifdef __MSDOS__
	return (strlwr(progname));
#else
	return progname;
#endif
}


/*
$Log: RCS/progname.c $
 * revision 1.3 Sugi 91/12/02 01:05:09
 * XCb`LN^Ɩ֌W '\'  '/' ̗
 * pX̋؂ƂĔF
 * 
 * revision 1.2 Sugi 91/01/27 00:08:22
 * XCb`LN^̕ύXɑΉ
 * 
 * revision 1.1 Sugi 91/01/05 18:44:27
 * Initial revision
 * 
 */
