/*
 *	common.h
 */

/* boolean */

#define FALSE			0
#define TRUE			!FALSE
#define NO				FALSE
#define YES				TRUE
#define NG				FALSE
#define OK				TRUE
#define OFF				0
#define ON				1
#define ERROR			(-1)
#define NOERROR			0
#define ERR				ERROR
#define NOERR			NOERROR

/* exit code */

#define USERERROR		1
#define SYSERROR		2
#define FATALERROR		(-1)
#define NOCOREERROR		(-1)

/* character */

#define EOS				'\0'
#define NUL				'\0'
#define TAB				'\t'
#define CR				'\r'
#define LF				'\n'
#define NL				'\n'
#define NEWLINE			NL
#define BELL			'\007'
#define BS				'\010'
#define VTAB			'\013'
#define FF				'\014'
#define SUB				'\032'
#define CPMEOF			SUB
#define ESC				'\033'
#define BLANK			'\040'
#define SPC				BLANK
#define DEL				'\177'
#define KANABLANK		'\240'

/* device name */

#define STDIN			"stdin"
#define STDOUT			"stdout"
#define STDERR			"stderr"
#define STDAUX			"stdaux"
#define STDPRN			"stdprn"

/* file handle */

#define hdlin			0
#define hdlout			1
#define hdlerr			2
#define hdlaux			3
#define hdlprn			4

/* type */

typedef int				BOOL;
typedef int				FLAG;
typedef int				HANDLE;			/* file handle */
typedef unsigned char	UCHAR;
typedef unsigned short	USHORT;
typedef unsigned int	UINT;
typedef unsigned long	ULONG;

/* class */

#define global
#define local			static

/* macro */

#define MASK			0377
#define UC(c)			((c) & MASK)
#define CTRL(c)			((c) & 037)
#define bit(n,nth)		(((n) >> (nth)) & ON)
#define biton(n,nth)	((n) | (ON << (nth)))
#define bitoff(n,nth)	(~(~(n) | (ON << (nth))))
#define toggle(flg)		((flg) = !(flg))
#define strtail(str)	(*(str) ? ((str) + strlen(str) - 1) : NULL)

#if !defined(LSI_C)
/* #include <io.h> */
#if !defined(O_BINARY) || !defined(O_TEXT)
#include <fcntl.h>
#endif
#define fsetbin(fp)		setmode(fileno(fp), O_BINARY)
#define fsettext(fp)	setmode(fileno(fp), O_TEXT)
#endif

#if defined(FP_SEG) && defined(FP_OFF) && !defined(MK_FP)
#define	MK_FP(s, o)	((void far *)(((unsigned long)(s) << 16)|(unsigned)(o)))
#endif
#if !defined(TURBO_C) && defined(MK_FP)
#define peek(s,o)		(*((int far *)MK_FP((s),(o))))
#define poke(s,o,w)		(*((int far *)MK_FP((s),(o))) = (int)(w))
#define peekb(s,o)		(*((char far *)MK_FP((s),(o))))
#define pokeb(s,o,b)	(*((char far *)MK_FP((s),(o))) = (char)(b))
#endif

#if defined(LSI_C)
#define iscflag(r)		((r).x.flags & 1)
#else
#define iscflag(r)		((r).x.cflag)
#endif


/*
$Log: RCS/common.h $
 * revision 1.7 Sugi 91/10/11 00:29:54
 * charcter 萔E}Nǉ
 * carry-flag }Nǉ(nˑ)
 * 
 * revision 1.6 Sugi 91/04/03 15:05:56
 * exit code 萔ǉ
 * 
 * revision 1.5 Sugi 91/02/14 03:37:03
 * BS ̃R[h 8iɂȂĂȂ^_^;
 * 
 * revision 1.4 Sugi 91/01/02 01:30:16
 * strtail() ̃oOC
 * 
 * revision 1.3 Sugi 90/11/30 20:57:34
 * MK_FP(), peek(), poke() ֌W}N̒ǉ(Turbo C Ƃ̌݊)
 * 
 * revision 1.2 Sugi 90/11/23 00:38:40
 * file handle ֌W萔̒ǉ
 * bit }N̒ǉ
 * 
 * revision 1.1 Sugi 90/11/08 23:40:48
 * Initial revision
 * 
 */
