/*
 * Please read maildir.c for license and information
 *
 */

#define MAILDIRPATH "Maildir"
	
typedef struct maildir_local {
  unsigned int inbox : 1;	/* if it is an INBOX or not */
  unsigned int dirty : 1;	/* diskcopy needs updating */
  char *dir;			/* mail directory name */
  char *buf;			/* temporary buffer */
  char *hdr;			/* current header */
  unsigned long buflen;		/* current size of temporary buffer */
  time_t scantime;		/* last time directory scanned */
} MAILDIRLOCAL;

/* Convenient access to local data */

#define LOCAL ((MAILDIRLOCAL *) stream->local)

/* Function prototypes */

DRIVER *maildir_valid (char *name);
int maildir_isvalid (char *name,long justname);
MAILSTREAM *maildir_open (MAILSTREAM *stream);
void maildir_gc (MAILSTREAM *stream,long gcflags);
void maildir_close (MAILSTREAM *stream, long options);
long maildir_ping (MAILSTREAM *stream);
long maildir_ping_core (MAILSTREAM *stream);
void maildir_check (MAILSTREAM *stream);
long maildir_fetchtext (MAILSTREAM *stream,unsigned long msgno,STRING *bs,long flags);
char *maildir_fetchheader (MAILSTREAM *stream,unsigned long msgno,
		unsigned long *length, long flags);
void maildir_fast (MAILSTREAM *stream,char *sequence,long flags);
void maildir_list (MAILSTREAM *stream,char *ref,char *pat);
void *maildir_parameters (long function,void *value);
long maildir_create (MAILSTREAM *stream,char *mailbox);
void maildir_flagmsg (MAILSTREAM *stream,MESSAGECACHE *elt);
void maildir_expunge (MAILSTREAM *stream);
long maildir_copy (MAILSTREAM *stream,char *sequence,char *mailbox,long options);
long maildir_append (MAILSTREAM *stream, char *mailbox, append_t af, void *data);
/* long maildir_append (MAILSTREAM *stream,char *mailbox,char *flags,char *date,
   STRING *message); */
short maildir_getflags (MAILSTREAM *stream,char *flag);
long maildir_delete (MAILSTREAM *stream,char *mailbox);
long maildir_rename (MAILSTREAM *stream,char *old,char *new);
long maildir_sub (MAILSTREAM *stream,char *mailbox);
long maildir_unsub (MAILSTREAM *stream,char *mailbox);
void maildir_lsub (MAILSTREAM *stream,char *ref,char *pat);

/* utility functions */
char *maildir_file (char *dst,char *name);
void maildir_copynew (const char *mailbox);
int maildir_select (struct direct *name);
/* int maildir_namesort (struct direct **d1,struct direct **d2); */
int maildir_namesort (const void *, const void *);
void maildir_listwork(char *name, MAILSTREAM *stream, char *s2, char *subdir, int flag);
