/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: vtrace.h,v 1.2 2000/01/15 01:02:19 chuckr Exp $
 * **********************************************************/

/*
 * vtrace.h --
 *
 *      Visual trace mechanism
 */

#ifndef _VTRACE_H_
#define _VTRACE_H_


#ifdef SUPPORT_VTRACE
/*
 * Functions
 */

#ifdef USERLEVEL
EXTERN Bool VTrace_Init(void);
EXTERN void VTrace_Exit(void);
EXTERN Bool VTrace_PowerOn(VM *vm);
EXTERN void VTrace_Enable(Bool enable);

#elif defined(MONITOR)
EXTERN void VTrace_Init(VM *vm);

#elif defined(MODULE)
EXTERN void VTrace_Init(VMDriver *vm);
EXTERN void VTrace_FreeAllResources(void);
#endif

EXTERN void VTrace_Set(int index, uint32 value);

#define VTRACE_ENABLE(_enable) VTrace_Enable(_enable)
#define VTRACE_SET(_indx,_value) VTrace_Set(_indx,_value)

#else 

#define VTRACE_ENABLE(_enable)
#define VTRACE_SET(_indx,_value)

#endif /* SUPPORT_VTRACE */
#endif
