/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: vm_types.h,v 1.2 2000/01/15 01:02:19 chuckr Exp $
 * **********************************************************/

/*
 *
 * vm_types.h -- 
 *
 *    basic data types.-- part of driver-only distribution.
 */

#ifndef _VM_TYPES_H_
#define _VM_TYPES_H_

#include "vm_basic_types.h"

#define EXTERN        extern
/*
 * Right now our use of CONST is broken enough that it only works
 * with GCC. XXX Need to fix this.
 */
#ifdef __GNUC__
#define CONST         const
#else
#ifndef CONST
#define CONST
#endif
#endif

#ifdef _MSC_VER
#ifndef INLINE
#define INLINE        __inline
#endif
#else
#ifndef INLINE
#define INLINE        __inline__
#endif
#endif

#ifndef PAGE_SHIFT
#define PAGE_SHIFT    12
#endif

#ifndef PAGE_SIZE
#define PAGE_SIZE     (1<<PAGE_SHIFT)
#endif

#ifndef PAGE_MASK
#define PAGE_MASK     (PAGE_SIZE - 1)
#endif

#ifndef NULL
#define NULL          ((void*)0)
#endif

typedef uint32 VA;
typedef uint32 VPN;

#define VA_2_VPN(_va)  ((_va) >> PAGE_SHIFT)
#define PTR_2_VPN(_ptr) VA_2_VPN((uint32)(_ptr))
#define VPN_2_VA(_vpn) ((_vpn) << PAGE_SHIFT)

typedef uint32 PA;
typedef uint32 PPN;
#define PA_2_PPN(_pa)  ((_pa) >> PAGE_SHIFT)
#define PPN_2_PA(_ppn) ((_ppn) << PAGE_SHIFT)

typedef uint32 MA;
typedef uint32 MPN;
#define MPN_2_KSEG(_mpn)  ((_mpn) << PAGE_SHIFT)
#define MPN_2_MA(_mpn)    ((_mpn) << PAGE_SHIFT)
#define MA_2_KSEG(_ma)    (_ma)
#define MA_2_MPN(_ma)     ((_ma) >> PAGE_SHIFT)

typedef uint32 LA;
typedef uint32 LPN;
#define LA_2_LPN(_la)     ((_la)>>PAGE_SHIFT)
#define LPN_2_LA(_lpn)    ((_lpn) << PAGE_SHIFT)


#ifndef PAGE_OFFSET
#define PAGE_OFFSET(_addr)  ((_addr)&(PAGE_SIZE-1))
#endif

typedef int    SegName;
typedef uint32 PDE;
typedef uint32 PTE;
typedef int32  Reg;
typedef uint8 *TCA;
typedef int32  IRQ;



/*
 * IRQ
 */


#define NOIRQ -1
#define LEGAL_IRQ(_irq) ( ((_irq)==NOIRQ) || ((_irq)>=0 && (_irq)<16))

#ifndef _WIN32
#define LOWORD(_dw)   ((_dw) & 0xffff)
#endif

#ifdef MONITOR
#ifdef _WIN32
#  define LOWORD(_dw)   ((_dw) & 0xffff)
#endif
#define HIWORD(_dw)   (((_dw) >> 16) & 0xffff)

#define LOBYTE(_w)    ((_w) & 0xff)
#define HIBYTE(_w)    (((_w) >> 8) & 0xff)

#define LODWORD(_dw)   ((uint32)((_dw) & 0xffffffff))

#ifdef __GNUC__
#  define HIDWORD(_dw)  ((uint32)(((_dw) >> 32) & 0xffffffff))
#elif _WIN32
static INLINE uint32 HIDWORD(uint64 y) 
{ 
   uint32 *ptr = (uint32 *)&y;
   return ptr[1];
}
#else
#  error Unknown platform
#endif

#define MERGE_LOBYTE(_w, _b)    (((_w) & ~0x00ff) | ((_b) & 0x00ff))
#define MERGE_HIBYTE(_w, _b)    (((_w) & ~0xff00) | (((_b) << 8) & 0xff00))

#define DWORD(_hi, _lo)         ((((uint64)(_hi))<<32) | (((uint64)(_lo)) & 0xffffffff))

#endif

/* XXX move to where genexc is defined */
#define EXC_SRC_INTERNAL  1
#define EXC_SRC_IRQ       2
#define EXC_SRC_INT       3

#ifndef offsetof
#define offsetof(type, member) ( (int) & ((type*)0) -> member )
#endif


#ifndef MIN
#define MIN(_a, _b)   (((_a) < (_b)) ? (_a) : (_b))
#endif
#ifndef MAX
#define MAX(_a, _b)   (((_a) > (_b)) ? (_a) : (_b))
#endif

#define ROUNDUP(x,y)		(((x) + (y) - 1) / (y) * (y))
#define ROUNDDOWN(x,y)		((x) / (y) * (y))
#define ROUNDUPBITS(x, bits)	(((uint32) (x) + MASK(bits)) & ~MASK(bits))
#define ROUNDDOWNBITS(x, bits)	((uint32) (x) & ~MASK(bits))
#define CEILING(x, y)		(((x) + (y) - 1) / (y))
#define MASK(n)			((1 << (n)) - 1)	// make an n-bit mask

/* 
   Deposit a field _src at _pos bits from the right, with a length of _len,
   into the integer _target. 
*/

#define DEPOSIT_BITS(_src,_pos,_len,_target) { \
	unsigned mask = ((1 << _len) - 1); \
	unsigned shiftedmask = ((1 << _len) - 1) << _pos; \
	_target = (_target & ~shiftedmask) | ((_src & mask) << _pos); \
}


#ifdef MONITOR

extern int sprintf(char *, char *,...);
extern int vsprintf(char *,...);

#endif /* MONITOR */


#endif
