/* **********************************************************
 * Copyright (C) 1999-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: memmgmt.h,v 1.2 2000/01/15 01:02:18 chuckr Exp $
 * **********************************************************/

/*
 * Memory management data structures passed between the user app
 * and the driver.
 */
#ifndef _MEMMGMT_H
#define _MEMMGMT_H

#include "vm_types.h"

/*
 * Data structures to pass to the GET_SET_INFO call to the driver.
 * If any value is < 0, then the value is not set.
 */
typedef struct VMMemMgmtInfo {
   int32   pageFaultRate;
   int32   lockFailRate;
   int32   maxLocked;
   int32   currentLocked;
   int32   highWaterMark;
   int32   waitingForMemoryTime;
   int32   poweringOn;
   int32   hasFocus;
} VMMemMgmtInfo;

typedef struct VMGetSetMemInfoInArgs {
   VMMemMgmtInfo info;
} VMGetSetMemInfoInArgs;

typedef struct VMGetSetMemInfoOutArgs {
   uint32         numVMs;
   uint32         numLockedPages;
   uint32         maxLockedPages;
   uint32         callerIndex;
   VMMemMgmtInfo  memMgmtInfo[1];
} VMGetSetMemInfoOutArgs;

#define VM_GET_INFO_SIZE(numVMs) ((numVMs - 1) * sizeof(VMMemMgmtInfo) + \
                                   sizeof(VMGetSetMemInfoOutArgs))

#endif
