/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: iocontrols.h,v 1.4 2000/01/15 01:02:17 chuckr Exp $
 * **********************************************************/


/*
 * iocontrols.h
 *
 *        The driver io controls.
 */

#ifndef _IOCONTROL_H
#define _IOCONTROL_H


typedef enum IOCTLCmd { 
   IOCTLCMD_NONE=200,
   IOCTLCMD_INIT,
   IOCTLCMD_LATE_INIT,
   IOCTLCMD_RUN,
   IOCTLCMD_LOOKUPMPN,
   IOCTLCMD_BEEP, 
   IOCTLCMD_SETUID, /* Linux and VMX86_DEVEL only */
   IOCTLCMD_LOCKPAGE, 
   IOCTLCMD_UNLOCKPAGE, 
   IOCTLCMD_ISMPSAFE,
   IOCTLCMD_APICBASE,
   IOCTLCMD_IOAPICBASE,
   IOCTLCMD_REGISTER_PASSTHROUGH_IO,
   IOCTLCMD_REGISTER_PASSTHROUGH_IRQ,
   IOCTLCMD_FREE_PASSTHROUGH_IO,
   IOCTLCMD_FREE_PASSTHROUGH_IRQ,
   IOCTLCMD_START_PASSTHROUGH,
   IOCTLCMD_STOP_PASSTHROUGH,
   IOCTLCMD_QUERY_PASSTHROUGH,
   IOCTLCMD_GET_NUM_VMS,
   IOCTLCMD_DECLARE_SLAVE,
   IOCTLCMD_CHECK_MEMORY,
   IOCTLCMD_BLUE_SCREEN,
   IOCTLCMD_ALLOW_CORE_DUMP,
   IOCTLCMD_GETSTATS,
   IOCTLCMD_SETSTATS,
   IOCTLCMD_SET_HARD_LIMIT,
   IOCTLCMD_GET_HARD_LIMIT,
   IOCTLCMD_GET_SET_MEM_INFO,
   IOCTLCMD_GET_MEM_INFO,
   IOCTLCMD_SET_MEM_INFO,
   IOCTLCMD_GET_VM_LIST,
   IOCTLCMD_GET_VM_INFO,
   IOCTLCMD_SET_VM_INFO,
   IOCTLCMD_BROADCAST_IPI, /* Linux SMP 2.2.8+ only */
   IOCTLCMD_FREE_RESOURCES, /* Linux only */
   IOCTLCMD_REDUCE_HARD_LIMIT, /* Windows 2000 only */
   IOCTLCMD_LAST
} IOCTLCmd;

#ifdef _WIN32

#define FILE_DEVICE_VMX86        0x8101
#define VMX86_IOCTL_BASE_INDEX   0x801

#define IOCTL_VMX86_INIT        CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_INIT,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_LATE_INIT   CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_LATE_INIT,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

/* We are using the IRP Information filed for the return value.
 * We did it to be faster since this IOCTL is use a lot.
 */
#define IOCTL_VMX86_RUN        CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_RUN,  \
                                             METHOD_NEITHER,     \
                                              FILE_ANY_ACCESS)


#define IOCTL_VMX86_LOOKUPMPN   CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_LOOKUPMPN,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_BEEP   CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_BEEP,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_LOCKPAGE   CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_LOCKPAGE,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_UNLOCKPAGE   CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_UNLOCKPAGE,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_APICBASE   CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_APICBASE,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_IOAPICBASE   CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_IOAPICBASE,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#ifdef USE_BLUE_SCREEN
#define IOCTL_VMX86_BLUE_SCREEN  CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_BLUE_SCREEN,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)
#endif

#define IOCTL_VMX86_GETSTATS	 CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_GETSTATS,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_SETSTATS	 CTL_CODE(FILE_DEVICE_VMX86 , \
                                 VMX86_IOCTL_BASE_INDEX+IOCTLCMD_SETSTATS,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_SETHARDLIMIT	 CTL_CODE(FILE_DEVICE_VMX86 , \
                                       VMX86_IOCTL_BASE_INDEX+IOCTLCMD_SET_HARD_LIMIT,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_GETHARDLIMIT	 CTL_CODE(FILE_DEVICE_VMX86 , \
                                          VMX86_IOCTL_BASE_INDEX+IOCTLCMD_GET_HARD_LIMIT,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_GETSETMEMINFO CTL_CODE(FILE_DEVICE_VMX86 , \
                                          VMX86_IOCTL_BASE_INDEX+IOCTLCMD_GET_SET_MEM_INFO,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_GETMEMINFO	         CTL_CODE(FILE_DEVICE_VMX86 , \
                                          VMX86_IOCTL_BASE_INDEX+IOCTLCMD_GET_MEM_INFO,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_SETMEMINFO	         CTL_CODE(FILE_DEVICE_VMX86 , \
                                          VMX86_IOCTL_BASE_INDEX+IOCTLCMD_SET_MEM_INFO,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_GETNUMVMS	         CTL_CODE(FILE_DEVICE_VMX86 , \
                                          VMX86_IOCTL_BASE_INDEX+IOCTLCMD_GET_NUM_VMS,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_GETVMLIST	         CTL_CODE(FILE_DEVICE_VMX86 , \
                                          VMX86_IOCTL_BASE_INDEX+IOCTLCMD_GET_VM_LIST,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_GETVMINFO	         CTL_CODE(FILE_DEVICE_VMX86 , \
                                          VMX86_IOCTL_BASE_INDEX+IOCTLCMD_GET_VM_INFO,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_SETVMINFO	         CTL_CODE(FILE_DEVICE_VMX86 , \
                                          VMX86_IOCTL_BASE_INDEX+IOCTLCMD_SET_VM_INFO,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)

#define IOCTL_VMX86_REDUCEHARDLIMIT	 CTL_CODE(FILE_DEVICE_VMX86 , \
                                       VMX86_IOCTL_BASE_INDEX+IOCTLCMD_REDUCE_HARD_LIMIT,  \
                                             METHOD_BUFFERED,     \
                                              FILE_ANY_ACCESS)
#endif

typedef struct {
  uint32	userLockedPages;	/* current count of pages locked by app */
  uint32	maxUserLockedPages;	/* max over time of pages locked by app */
  uint32	monitorLockedPages;	/* current count of pages locked by monitor */
  uint32	maxMonitorLockedPages;	/* max over time of pages locked by monitor */
} VMX86Stats;

/*
 * Return codes from lock page if lock page failed.
 *
 *    PAGE_LOCK_FAILED              The host refused to lock a page.
 *    PAGE_LOCK_LIMIT_EXCEEDED      We have reached the limit of locked pages for all VMs
 */
#define PAGE_LOCK_FAILED                  0
#define PAGE_LOCK_LIMIT_EXCEEDED         -1

#define VM_NAME_LENGTH        64
#define VM_USER_NAME_LENGTH   32

/*
 * Structure returned from GET_VM_LIST ioctl.
 */
typedef struct {
   uint32   vmCount;
   uint32   vmUIDs[1];
} VMGetVMListResult;

typedef enum {
   VM_INFO_OFF,
   VM_INFO_RUNNING,
   VM_INFO_SUSPENDED,
   VM_INFO_BLOCKED,
} VMInfoState;

/*
 * Structure sent into VM_SET_INFO ioctl.
 */
typedef struct {
   uint32		port;
   char			name[VM_NAME_LENGTH];
   char     		userName[VM_USER_NAME_LENGTH];
   VMInfoState 		state;
} VMSetVMInfoArgs;
/*
 * Structure returned from GET_VM_INFO ioctl.
 */
typedef struct {
   uint32         vmUID;
   int32          port;
   char           name[VM_NAME_LENGTH];
   char           userName[VM_USER_NAME_LENGTH];
   VMInfoState	  state;
} VMGetVMInfoResult;

#endif
