/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: memtrack.h,v 1.2 2000/01/15 01:02:40 chuckr Exp $
 * **********************************************************/

/************************************************************
 *
 * memtrack.h  - Utility module for tracking memory allocated 
 *               and/or locked by the driver. 
 *
 ************************************************************/


#ifndef MEMTRACK_H
#define MEMTRACK_H

#include "vm_types.h"

typedef struct MemTrackEntry {
  VPN vpn;
  MPN mpn;
  struct MemTrackEntry *hashChain;
   /* User defined data follows */
} MemTrackEntry;

extern void *MemTrack_Init(int sizeOfEntry);
extern MemTrackEntry *MemTrack_Add(void *s, VPN vpn, MPN mpn);
extern MemTrackEntry *MemTrack_LookupVPN(void *s, VPN vpn);
extern int MemTrack_Cleanup(void *s, void (*cleanProc)(void *, MemTrackEntry *), void *clientData);
extern void *MemTrack_Scan(void *s, void *arg,
            void *(*searchFunc)(void *arg, MemTrackEntry *entryPtr)); 

#endif 
