;;; -*- Emacs-Lisp -*-
;;; (c)1999-2003 HIROSE Yuuji [yuuji@gentei.org]
;;; Set up all diary environment
;;; Last modified Sun Mar  5 18:41:01 2006 on firestorm
;;; $Id: webdiary.el,v 2.2 2008/02/24 21:21:50 yuuji Exp $

;;; ~/.emacs $B$K0J2<$N9T$rDI2C$9$k!#(B
;;;
;;;	(autoload 'webdiary "webdiary" "Keep web diary!" t)
;;;
;;; M-x webdiary $B$GF|5-$r=q$3$&!#(B
;;;
;;; $B$*$^$1(B
;;;	$B%j%8%g%s;XDj$7$F(B M-x webdiary-body2html
;;;	$B$9$k$H$=$NNN0h$r(B body2html $B$G(BHTML$B2=$9$k$>!#(B
;;;	body2html $B$N(BHTML$B2=5,B'$K4X$7$F$O(Bbody2html $B%9%/%j%W%H$r8+$F$/$l$$!#(B
;;;
;;;	(autoload 'webdiary-body2html "webdiary" "en-HTML!" t)
;;;	(define-key global-map "\C-cH" 'webdiary-body2html)
;;;
;;;	$B$H$+$7$H$/$H$($($h!#(B

(defvar webdiary:dir "~/http/diary/"
  "*$BF|5-$N4p=`$H$J$k%G%#%l%/%H%j(B ( / $B$G=*$o$i$;$k$3$H(B)")

(defvar webdiary:mkdiary (expand-file-name "mkdiary.rb" webdiary:dir)
  "*$BF|5-%G%#%l%/%H%j99?7MQ%9%/%j%W%H(B mkdiary $B$N%U%k%Q%9(B")

(defvar webdiary:body2html (expand-file-name "body2html" webdiary:dir)
  "*$B%W%l%$%s%F%-%9%HK\J8$r(BHTML$B2=$9$k%9%/%j%W%H(B body2html $B$N%U%k%Q%9(B")

(defun webdiary*today ()
  "$B:#F|$NF|IU(B YYYY/MM/DD"
  (let* ((ts (current-time-string))
	 (m (substring ts 4 7))
	 (d (substring ts 8 10))
	 (y (substring ts -4)))
    (setq m (cdr (assoc m '(("Jan" . 1) ("Feb" . 2) ("Mar" . 3) ("Apr" . 4)
			    ("May" . 5) ("Jun" . 6) ("Jul" . 7) ("Aug" . 8)
			    ("Sep" . 9)("Oct" . 10)("Nov" . 11)("Dec" . 12))))
	  m (format "%02d" m)
	  d (format "%02d" (string-to-int d)))
    (format "%s/%s/%s" y m d)))

(defun webdiary*update-yeardir ()
  "$B!VG/!W$N(Bindex$B%U%!%$%k$r99?7(B"
  (save-restriction
    (save-excursion
      (let ((dir (file-name-directory webdiary:mkdiary)))
	(widen)
	(goto-char (point-min))
	(and (re-search-forward "<[Hh]1>" nil t)
	     (progn (skip-chars-forward " \t\n")
		    (not (looking-at "</h1>")))
	     (progn
	       (start-process
		"mkdiary"
		" *mkdiary*"
		(expand-file-name webdiary:mkdiary)
		"../..")
	       (start-process
		"mkdiary"
		" *mkdiary*"
		(expand-file-name webdiary:mkdiary)
		"-mkcat")
	       (cond
		((file-exists-p (expand-file-name "rss.rb" dir))
		 (unwind-protect
		     (let ((default-directory dir))
		       (cd default-directory)
		       (call-process
			shell-file-name 
			nil nil nil
			shell-command-switch
			"./rss.rb"))
		   (cd default-directory)))))
	     nil))))
  nil)

(defun webdiary-body2html (beg end)
  (interactive "r")
  (save-excursion
    (shell-command-on-region beg end webdiary:body2html nil t)))

(defun webdiary (date)
  "web$BF|5-%;%C%H%"%C%W(B"
  (interactive
   (let ((wd webdiary:dir)
	 (td (webdiary*today)))
     (or (string-match "/$" wd)
	 (setq wd (concat wd "/")))
     (list
      (read-file-name "Today: " wd (expand-file-name td wd) nil td))))
  ;;$B:#F|$N%G%#%l%/%H%j$r7!$k(B
  ;(or (file-directory-p date) (make-directory date))
  ;;$B%F%s%W%l!<%H%U%!%$%k$r:n@.(B
  (let ((target (expand-file-name "index.html" date))
	(ymd (substring date -10)))
    (if (not (file-exists-p target))
	(call-process webdiary:mkdiary nil nil nil "-date" ymd))
    (find-file target)
    (add-hook (make-local-variable 'after-save-hook)
	      'webdiary*update-yeardir)))

(defun webdiary-on-dir (dir)
  "Call webdiary with special directory."
  (let ((mkdiary (expand-file-name "mkdiary.rb" dir)))
    (let*((webdiary:dir dir)
	  (webdiary:mkdiary mkdiary))
      (call-interactively 'webdiary))
    (set (make-local-variable 'webdiary:mkdiary) mkdiary)))


(autoload 'img2www "img2www" "An interface to img2www script" t)
(provide 'webdiary)
