#!/usr/bin/env ruby19
# coding: euc-jp
# make diary's index files
# $HGid: mkdiary.rb,v 82:baef5209bf7c 2024-04-29 16:18 +0900 yuuji $
# Last modified Mon Apr 29 16:16:35 2024 on firestorm

#$DEBUG = true;

def usage()
    print <<_EOU_
ǯ// Ȥǥ쥯ȥ깽ĤΡ
ַפǥ쥯ȥindex.htmlޤ
index.htmlϡȤаʲΤ褦ʸФˤʤޤ
  12
	1 - 
	25 - ϥꥹޥ
줾Υȥϡ12/01/index.html, 12/25/index.html ˺ǽ
H1ȤȤʤޤ

ưˡ: mkdiary.rb ַץǥ쥯ȥ
ʲΥץ󤬻ѤǤޤ
	-bg			index.htmlطʿ
	-c confե		ưե(~/.#{$mybase}rc)
	-date ǯ//	Υƥץ졼HTMLǤФ
	-s			Stream(ᥤǼưϿ)⡼
	-mkcat			ƥꥤǥåǤФ

ܤ http://www.gentei.org/~yuuji/diary/mkdiary/manual.html ߤƤ硣
_EOU_
    exit 0
end

##
# Global variables
##
$mydir=''; $myname=''; $wday=''; $date=''; $youbi='';
require 'kconv'

$mydir, $myname = $0.scan(%r,(.*)/(.*),)[0]
$mybase = $myname.scan(/([^.]*)(\.rb)?/)[0][0]

$opt =
{ 'bg'=>	"lightseagreen",
  'fg'=>	"",				# (ʸ)
  'tojis'=>	"/usr/local/bin/nkf -j",	# Ǥբjis
  'toeuc'=>	"/usr/local/bin/nkf -e",	# Ǥբeuc
  'euctojis'=>	"/usr/local/bin/nkf -Ej",	# eucjis
  'outcode'=>	"jis",				# ե륳(eucjis)
  'decode64'=>	 "/usr/local/bin/mewdecode",	# base64ǥɥץ
  'titleleft'=>	"",				# ɽκ¦ˤĤ  Ȥ
  'titleright'=>"",				# ɽα¦ˤĤ  Ȥ
  'header'=>	"#{$mydir}/header",		# htmlƬˤĤ
  'footer'=>	"#{$mydir}/footer",		# htmlˤĤ
  'yheader'=>	"#{$mydir}/yheader",		# ǯhtmlƬˤĤ
  'yfooter'=>	"#{$mydir}/yfooter",		# ǯhtmlˤĤ
  'day_ascend'=>1,				# դ򾺽˥
  'need_wday'=>	1,				# ɽդ
  'body_opt'=>	"",				# bodyդ¾Υץ
  'word_DIARY'=>"Diary",			# ȥ˻ȤDiaryȤñ
  'yearformat'=>"%dǯ",			# ǯINDEXΥȥ
  'css_yearly'=>"",				# ǯINDEXcssե(ɬפʤ)
  'yearleading'=>"",				# ǯINDEXΥȥľʸ
  'monthheading'=>1,				# Xɽ򤹤
  'nohr'=>0,					# ζڤ<hr>Ĥʤ
  'conf'=>	"#{ENV['HOME']}/.#{$mybase}rc",
  'addpath'=>					# ưɲäPATH
   "/usr/local/bin:/usr/local/bin/ImageMagick:/usr/local/bin/Graphics:/usr/local/bin/Netpbm",
  'debugfile'=>	"#{$mydir}/debug",		# debugåե
  'mail'=>	"/usr/bin/mail",		# mailޥɤΥѥ
  'notify'=>	0,				# mailΤ뤫ɤ
  'ownotify'=>	1,				# mailξ
  'img2www'=>	"img2www -1",			# autoimg
  'gnutar'=>	"gtar",				# GNU tar ޥ
  'unzip'=>	"unzip",			# zipեŸѥޥ
  'lha'=>	"lha",				# lzhեŸѥޥ
  'bodyfilter'=>"",				# ʸ򿩤魯ե륿ޥ
  'bmp2jpg'=>	0,				# BMPJPEGˤ뤫
  'bmp2png'=>	0,				# BMPPNGˤ뤫
  'convert'=>	"convert",			# convertޥ
  'mup-p'=>	nil,				# Фꤷ
  'categtbl'=>	"category.tbl",			# ƥʬѥɽ
  'categdir'=>	"category",			# ƥʬǥ쥯ȥ
  'cldprefix'=>	"",  #"../",			# Category Link Dir prefix
  'cutstr'=>	"\nGenerated with",		# Cut after this when mkcat
  'themes'=>	"%s˴ؤޤ",		#
  'other'=>	"ˤʬवʤ",	#
  'm'=>		nil,				# ǥեȤθФ
}

class Initter
  def initialize()

    # Get current directory correctly
    cwd = Dir.pwd
    Dir.chdir $mydir
    $mydir = Dir.pwd
    Dir.chdir cwd

    # readonly options
    $readonlyopts = {}
    setoptreadonly('allow', 'owner')

    # read configuration
    readconf()
    $outfilter = (/euc/i =~ $opt['outcode']) ? $opt['toeuc'] : $opt['tojis']
  end

  def readconf()
    conf = $opt['conf']
    test(?f, "#{$mydir}/.#{$mybase}rc") and
      conf = "#{$mydir}/.#{$mybase}rc"
    return unless test(?f, conf)
    return unless File.size(conf)
    open(conf, "r"){|cf|
      var = continue = nil
      while cf.gets
	if ~/^$/ then
	  var = continue = nil
	elsif ~/^\s*\#/ then
	  next
	elsif continue && var then # continue line (preceded by \)
	  # add this line literally to last set variable
	  if ~/\\$/ then
	    continule = true
	    $opt[var] << $`
	  else
	    $opt[var] << $`
	    continue = false
	  end
	elsif ~/^\s(\s*\S.*)$/ && var then # continue line with \n
	  # add \n and this line with one preceding white space stripped
	  # to last set variable
	  rest = $1
	  if /\\$/ =~ rest then
	    continue = true
	    $opt[var] << "\n"+$`
	  else
	    $opt[var] << "\n"+rest
	    continue = false
	  end
	else
	  var, val = $_.scan(%r,([^= \t]+)\s*=\s*(.*)$,)[0]
	  if var then
	    val.sub!(/^([\"\'])(.*)\1/, "\\2")
	    if /\\$/ =~ val then# continue line
	      val = $`
	      continue = true
	    else
	      continue = false
	    end
	    $opt[var] = val
	    $DEBUG and print "#{var} set to [#{val}]\n"
	  end
	end
      end
    }
  end
end

def setoptreadonly(*opts)
  opts.each{|o| $readonlyopts[o] = true}
end
def isoptreadonly(opt)
  return $readonlyopts[opt]
end

def day_week(y, m, d)
  "(" +
    ["", "", "", "", "", "", ""]\
    [Time.mktime(y, m, d).strftime("%w").to_i] +
    ")"
end

class DateKeeper
  def initialize(datestr = Time.now.strftime("%Y/%m/%d"))
    ((@y, @m, @d)) = datestr.scan(%r,(\d\d\d\d+)/([01]?\d)/([0-3]?\d),)
    @date = datestr.dup
    t = Time.mktime(@y, @m, @d)
    wday = t.wday
    @youbi = ["", "", "", "", "", "", ""][wday]
    @wday = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"][wday]
  end
  def wday()
    @wday
  end
  def youbi()
    @youbi
  end
  def year()
    @y
  end
  def gsubkeywords(line)
    line.gsub!(/%DIARY%/, $opt['word_DIARY'])
    line.gsub!(/%TITLE%/, $opt['word_DIARY'] + " of " + @date)
    line.gsub!(/%BG%/, $opt['bg'])
    line.gsub!(/%FG%/, $opt['fg'])
    line.gsub!(/%DATE%/, @date)
    line.gsub!(/%YEAR%/, @y)
    line.gsub!(/%MONTH%/, @m)
    line.gsub!(/%DAY%/, @d)
    line.gsub!(/%WDAY%/, @wday)
    line.gsub!(/%YOUBI%/, @youbi)
    line.gsub!(/%HEADING%/, $opt['m']||(@m+"-"+@d))
    css = test(?s, "diary.css") ? \
    '<link rel="stylesheet" type="text/css" href="../../../diary.css">' \
    : ''
    line.gsub!(/%USERCSS%/, css) 
    line
  end
  def header(file = $opt['header'])
    str = ''
    test(?r, file) or bye "Cannot open header file `#{file}'"
    open(file, "r").each{|line|
      str << gsubkeywords(line.toeuc)
    }
    str
  end
  def footer()
    header($opt['footer'])
  end
  def create()
    date = @date
    Dir.chdir $mydir
    test(?w, $mydir) or
      bye("Cannot output to the directory [#{$mydir}].\n" +
	  "Please put #{$myname} into your diary's top directory.\n" +
	  "#{$mydir} ˽񤭹ߤǤޤ.\n" |
	  "#{$myname} ǥ쥯ȥ֤Ƥ\n")
    %r,\d\d\d\d+/\d\d?/\d\d?, =~ date or
      bye("Specify the date like 2002/01/23 instead of #{date}.\n" +
	  "դ #{$date} ʤ 2002/01/23 Τ褦˻ꤷƲ.\n")

    # Preperation
    mkdir_p(date)
    test(?r, $opt['header']) or
      bye("Create the header template into the file #{$opt['header']}.\n" +
	  "#{$opt['header']} ȤեhtmlƬθܤȤƤ")
    test(?r, $opt['footer']) or
      bye("You should create the footer template into #{$opt['footer']}.\n" +
	  "#{$opt['footer']} ȤեhtmlθܤȤƤ")
    # Generate header and footer
    hdr, ftr = header(), footer()
    index = "#{date}/index.html"
    if ! test(?s, index) then
      print "Creating the template of diary file on #{date}.\n" unless $quiet
      begin
	open("| #{$outfilter} > #{index}", "w"){|ix|
	  ix.print hdr+ftr
	}
	open(index, "r").each{|l|print l} unless $quiet
      rescue
	bye "Cannot output to file [#{index}].\n"
      end
    else
      print "Done nothing...#{index} alread exists.\n" unless $quiet
    end
  end
end

def daytitle(dir, text = nil)
  # Return the title according to the argument DIR
  title = []
  index = "#{dir}/index.html"
  size = File.size(index)
  s = Kconv.toeuc(text || open(index, "r"){|ix|ix.read(size)})
  s.gsub!(/\n/, '').split(%r,<H1>,i).grep(%r,</h1>,i).collect{|x|
    x.sub!(%r$</H1>.*$i, '').strip!
    $opt['titleleft'] + x + $opt['titleright']
  }.join(',')
end

def monthlist(monthdir)
  list = {}
  Dir.open(monthdir).select{|f|
    %r,\d\d?, =~ f && test(?d, "#{monthdir}/#{f}")
  }.each{|day|
    test(?s, "#{monthdir}/#{day}/index.html").to_i > 0 and
      list[day] = daytitle("#{monthdir}/#{day}")
  }
  list
end

def bye(msg)
  STDERR.print msg+"\nGood bye.\n"
  abort
end

def checkopt(option)
  # Compatible true/false check with perl
  x = $opt[option]
  if x.is_a?(Numeric) then
    x != 0
  elsif x.is_a?(String) then
    if /^\d+$/ =~ x then
      x.to_i != 0
    else
      x > ""
    end
  elsif x.is_a?(Array) then
    x.length > 0
  end
end

def mydirname(dir)
  # Get the directory name of DIR
  # even if DIR is ended with `.' or `..'
  myino = File.stat(dir).ino
  if myino == File.stat("#{dir}/..").ino
    bye "Do not call me with ROOT directory."
  end
  parent = "#{dir}/.."
  begin
    d = Dir.open(parent).select{|f|
      test(?d, "#{parent}/#{f}") && myino == File.stat("#{parent}/#{f}").ino
    }
    if d then return d[0] else return nil end
  rescue
    bye "Cannot read directory [#{parent}].\nPlease chmod +r there"
  end
end

def mkyearindex(yeardir)
  test(?d, yeardir) or
    bye "I Cannot find year-directory [#{yeardir}]... Please mkdir it"
  y = mydirname(yeardir)
  m = day = title = dir = nil	# local variables
  text = checkopt('fg') ? $opt['fg'] : "black"
  /\d\d\d\d+/ =~ y or
    bye "Please specify 4-digit year directory instead of `#{y}'\n" +
    "#{y}ʤǯΥǥ쥯ȥꤷƤ"

  # Create header
  begin
    # open("|#{$outfilter} > hoge", "w") {|index|
    open("|#{$outfilter} > #{yeardir}/index.html", "w") {|index|
      if checkopt('yheader') and test(?s, $opt['yheader']) then
	index.print(if y.to_i == Time.now.year then
		       DateKeeper.new(Time.now.strftime("%Y/%m/%d"))
		     else
		       DateKeeper.new("#{y}/1/1")
		     end.header($opt['yheader']))
      else			# backward compatibility
	index.printf <<_EOS_, $opt['css_yearly'] > "" ? <<-_EOS2_ : ''
<html>
<head><title>#{$opt['word_DIARY']} of #{y}</title>
#{$opt['yearstyle']}%s</head>
<body text="#{text}" bgcolor="#{$opt['bg']}"#{$opt['body_opt']}>
_EOS_
<link rel="stylesheet" type="text/css" href="#{$opt['css_yearly']}">
	_EOS2_
	yf = $opt['yearformat']
	while /%d/ =~ yf
	  yf = sprintf(yf, y)
	end
	index.print("<h1>#{yf}</h1>\n")
	checkopt('yearleading') and index.print $opt['yearleading']+"\n"
      end
      index.print "<dl>\n"
      begin
	sortfunc = if checkopt('day_ascend') then
		     lambda {|a, b| a.to_i <=> b.to_i}
		   else
		     lambda {|a, b| b.to_i <=> a.to_i}
		   end
	dir = Dir.open(yeardir).select{|d|
	  %r,\d+$, =~ d && test(?d, "#{yeardir}/#{d}")
	}.sort{|a, b|
	  b.to_i <=> a.to_i	# months in newer2older order
	}.each{|m|
	  if checkopt('monthheading') then
	    checkopt('nohr') or index.print "\n"
	    index.printf " <dt> %d\n", m.to_i
	  end
	  title = monthlist("#{yeardir}/#{m}")

	  title.keys.sort{|xx, yy| sortfunc.call(xx, yy)}.each{|day|
	    index.printf " <dd> <a href=\"%s/%s/\">%s%02d%s</a>%s - %s\n",
	      m, day,
              checkopt('monthheading') ? '' : "#{m}/",
	      day.to_i,
	      checkopt('monthheading') ? '' : "",
	      checkopt('need_wday') ? day_week(y, m, day) : '',
	      title[day]
	  }
	}
	index.print "</dl>\n"
	if test(?f, $opt['yfooter']) then
	  open($opt['yfooter'], "r").each{|line|
	    index.print line
	  }
	elsif test(?f, $opt['footer']) then
	  open($opt['footer'], "r").each{|line|
	    index.print line
	  }
	end
      rescue
	bye "Please chmod +r #{yeardir}"
      end
    }
  rescue
    bye "Cannot output to #{yeardir}/index.html"
  end
end

def mkdir_p(dir, mode = 0755)
  path = ''
  dir.split('/').each{|p|
    path << p
    unless test(?d, path) || path == ""
      Dir.mkdir(path, 0777)
      File.chmod(mode, path)
    end
    path << "/"
  }
end

def today()
  # ɤѤäƤ񤯤¿ȻפΤǡ
  # GMT9դǺäۤä:-)
  Time.now.gmtime.strftime("%Y/%m/%d")
end

def debugout(mesg)
  open($opt['debugfile'], "a"){|df|
    df.print mesg+"\n"
  }
end

def notifyto(to, subj, mes)		  # owner˥å
  begin
    open("| #{$opt['tojis']} | #{$opt['mail']} -s '#{subj}' #{to}", "w") {|m|
      m.print mes
    }
  rescue
    debugout("Cannot start $opt{mail} command");
  end
end



class Mail
  # @_s = nil
  @header = nil
  @body = []
  @text
  @date
  @theDAY
  @basedir
  @targetdir
  def initialize(basedir = $mydir)
    # @_s = stream
    @basedir = basedir
    @text = []
    @body = parseMessage
    @header = @body[0]
  end

  def parseMessage()
    header = parseHeader
    ### STDERR.puts "\header="+header.inspect
    @date = setDate(header['Subject'])

    @targetdir = @basedir + "/" + @date
    mkdir_p(@targetdir)
    @theDAY = DateKeeper.new(@date)	# Remember the target date
    return [header, parseBody(header)]
  end

  def setDate(subj)
    #now = Time.new.gmtime
    #y, m, d = now.year, now.month, now.day
    y, m, d = today.scan(%r,(\d\d\d\d+)[/ ]([01]?[0-9])[/ ]([0-3]?[0-9]),)[0]

    case subj
    when %r,(\d\d\d\d+)[/ ]([01]?[0-9])[/ ]([0-3]?[0-9]),
      y, m, d = $1, $2, $3
    when %r,([01]?[0-9])[/ ]([0-3]?[0-9]),
      m, d = $1, $2
    when /yesterday/i
      yesterday = Time.now-3600*24
      y, m, d = yesterday.year, yesterday.month, yesterday.day
    when /tomorrow/i
      tomorrow = Time.now+3600*24
      y, m, d = tomorrow.year, tomorrow.month, tomorrow.day
    when /(\d+)\s*days?.*ago/i
      ago = Time.now-3600*24*$1.to_i
      y, m, d = ago.year, ago.month, ago.day
    when /([0-3]?[0-9])/
      d = $1
    end
    # Regulate date values
    y, m, d = y.to_i, m.to_i, d.to_i
    if d > 31 || d < 1 || m > 12 || m < 1 || y < 1999 then
      y, m, d = today.scan(%r,(\d\d\d\d+)/([01]?[0-9])/([0-3]?[0-9]),)[0]
      notifyto($opt['owner'], 'mkdiary-warning-of-date',
	       "Invaild date format (#{subj})\n." +
	       "Set the date to todays (#{y}/#{m}/#{d}).\n" +
	       "ջ꤬ (#{subj}) Τ\n" +
	       "(#{y}/#{m}/#{d})˶Ūꤷޤ\n");
    end
    date = sprintf("%d/%02d/%02d", y.to_i, m.to_i, d.to_i)
    return date

  end

  def parseHeader()
    hdr = {}
    last = nil
    while gets
      $_.chop!
      break if ~/^$/
      if ~/^\s/ && last then
	$_.strip!
	hdr[last] << "\n #{$_}"
      elsif ~/^([A-z][^:]+):\s+(.*)/
	hdr[$1] = $2
	last = $1
      end
    end
    return hdr
  end

  def extract_archive(dir, file)
    # in:	"directory", "archivefile.ext"
    # job:	extract "archivefile.ext" in "directory"
    case file
    when /tar$/i
      extcmd = $opt['gnutar'] + " xpf"
    when /tar.(gz|Z)$/i
      extcmd = $opt['gnutar'] + " zxpf"
    when /zip$/i
      extcmd = $opt['unzip']
    when /(lzh|lha)$/i
      extcmd = $opt['lha'] + " x"
    else
      notifyto($opt['owner'], 'mkdiary-extract-method-unknown',
	       "Extracting method unknown for the attached file [#{file}].\n" +
	       "źդ #{file} Ÿˡ狼ޤ.\n" +
	       "lha, tar(+gzip), zip Τɤ줫ˤƤ.")
      return nil
    end
    extcmd << " " << file
    print "pid_parent=#{$$}\n" if $DEBUG
    # 
    if !pid=fork then
      if !p2=fork then
	ENV['PATH'] = "/bin:/usr/bin:/usr/local/bin:#{ENV['PATH']}"
	Dir.chdir dir
	STDIN.close; STDOUT.close
	begin
	  exec extcmd
	rescue
	  notifyto($opt['owner'], 'mkdiary-extract-exec-error',
		   "Cannot exec [#{extcmd}] #{$$}\n" +
		   "źդ #{file} Ÿ #{extcmd} ưǤʤ\n")
	  return false
	  exit 0
	end
	exit 0			# should not be here
      end
      sleep 10			# timer set to 10
      File.unlink("#{dir}/#{file}")
      begin
	Process.kill :KILL, p2
      rescue
	# p "No process to kill"
      end
      exit			# filter via mail should exit with 0
    end
    return true
  end

  def convert_img(dir, file)
    timeout = 3
    if checkopt('bmp2jpg') then
      fmt = 'jpg'
    elsif checkopt('bmp2png') then
      fmt = 'png'
    end
    return nil unless fmt
    target = file.sub(/\.(bmp|tiff?)$/, ".#{fmt}")
    parent = $$
    if !pid=fork then
      if !pid2=fork then
	ENV['PATH'] << ":/usr/bin:/usr/local/bin:/usr/local/bin/ImageMagick"
	Dir.chdir dir
	exec $opt['convert'], "-format", fmt, file, target
	exit 0			# filter via mail should exit with 0
      end
      sleep timeout
      begin
	Process.kill :KILL, pid2
      rescue
	# no process to kill
      end
      exit 0			# filter via mail should exit with 0
    end
    #Process.wait
    limit = Time.now+timeout
    while limit - Time.now > 0
      (p "#{dir}/#{target}", test(?s, "#{dir}/#{target}")) if $DEBUG
      sleep 0.3
      break if test(?s, "#{dir}/#{target}")
    end
    if test(?s, "#{dir}/#{target}") then
      File.unlink "#{dir}/#{file}" # remove original
    else
      notifyto($opt['owner'], 'mkdiary-convert-error',
	       "Failed to invoke 'convert' program, which comes with ImageMagick.\nInstall ImageMagick!\nźղ#{fmt}˼ԡ\nconvert(ImageMagick°)򥤥󥹥ȡ뤷ޤ礦")
    end
    return test(?s, "#{dir}/#{target}")
  end

  def extract_multipart(boundary)
    # in:	(multipart boundary string)
    # job:	extract all attached binary files into @targetdir
    # out:	all part as an array
    myBoundary  = "--#{boundary}\n"
    myBoundary2 = "--#{boundary}--\n"
    body = []
    imgcount=0
    while gets != myBoundary	# Skip to the first boundary
    end
    while (h=parseHeader()).length > 0
      ct = h['Content-Type']	# Current parts Content-Type
      fn=nil
      print "ct==============[#{ct}]\n" if $DEBUG
      ct.gsub!(/\n/, " ")
      if %r,text/plain,i =~ ct then 	# text/plain (not nested)
	text = []
	while gets
	  break if $_ == myBoundary
	  break if $_ == myBoundary2
	  text << $_
	  @text << $_
	end
        STDERR.puts "CTE="+h['Content-Transfer-Encoding']
        fromcode = ""
        if /charset=(\S+)/i =~ ct then
          case $1
          when /utf-8/i
            fromcode = "W"
          when /iso-2022/i
            fromcode = "J"
          when /euc-jp/i
            fromcode = "E"
          end
        end
        decoding = ""
        case h['Content-Transfer-Encoding']
        when /quoted-printable/i
          decoding = "mQ"
        when /base64/i
          decoding = "mB"
        end
        require 'nkf'
        if /base64/i =~ h['Content-Transfer-Encoding'] then
          text = NKF.nkf("-#{fromcode}e -mB", text.join).split(/(\n)/)
        elsif /quoted-printable/i =~h['Content-Transfer-Encoding'] then
          text = NKF.nkf("-#{fromcode}e -mQ", text.join).split(/(\n)/)
        elsif /8bit/i =~h['Content-Transfer-Encoding'] then
          text = NKF.nkf("-#{fromcode}e", text.join).split(/(\n)/)
        end
	body << text
      elsif %r,image|audio|video|application/octet-stream,i =~ ct &&
	  /^base64/i =~ h['Content-Transfer-Encoding']
	if /filename=(['"]?)([^';"]+)\1/ =~ h['Content-Disposition'] then
	  fn = $2
	end
	if !fn && %r,name=([\'\"]?)([^\'\"]+)\1,i =~ ct
	  fn = $2
	end
	if !fn then fn = "dummy.output" end

	# decode it
        fn.gsub!(%r|[^-A-Za-z0-9.,/+@%_]|, "_")
	filename = "#{@targetdir}/#{fn}"
	begin
	  um = File.umask(022)
	  open("| #{$opt['decode64']} > '#{filename}'", "w"){|f|
	    while gets
	      break if $_ == myBoundary || $_ == myBoundary2
	      f.print $_
	    end
	  }
	rescue
	  if !test(?s, filename)
	    notifyto($opt['owner'], 'mkdiarry-extract-decode64-not-found',
		     "Cannot exec #{$opt['decode64']} program."+
		     "| #{$opt['decode64']} > #{filename}"+
		     "\n(#{$!}), #{test(?s, filename)}")
	    while gets
	      break if $_ == myBoundary || $_ == myBoundary2
	    end			# Skip to the next part
	  end
	ensure
	  #### File.umask(um)
	end
	if test(?s, filename)
	  # when extracted successfully
	  case fn
	  when /lzh|tar(\.(gz|Z))?|tgz|zip/i
	    if extract_archive(@targetdir, fn) then
	      body << [:archive, fn]
	    end
	  when /\.(bmp|tiff?)$/i
	    if convert_img(@targetdir, fn) then
	      body << [:image, fn]
	    end
	    ENV["img_#{imgcount+=1}"]=fn
	    ENV["img_n"]=imgcount
	  else
	    body << [:image, fn]
	    ENV["img_#{imgcount+=1}"]=fn
	    ENV["img_n"]=imgcount.to_s
	  end
	end # when extracted successfully
      elsif /^multipart.*boundary=([\'\"]?)([^'"]+)\1/i =~ ct
	body << extract_multipart($2)
      else			# Unknown content-type
	while gets
	  break if $_ == myBoundary || $_ == myBoundary2
	end			# Skip to the next part
      end
      break if $_ == myBoundary2
    end
    body
  end

  def parseBody(header)
    (ct = header['Content-Type']).to_s.gsub!(/\n/, " ")
    if %r,Message/Rfc2?822|text/plain,i =~ ct || !ct # PlainText
      text = readlines
      cte = header['Content-Transfer-Encoding']
      if cte then
        fromcode = ""
        if /charset=(\S+)/i =~ ct then
          case $1
          when /utf-8/i
            fromcode = "W"
          when /iso-2022/i
            fromcode = "J"
          when /euc-jp/i
            fromcode = "E"
          end
        end
        require 'nkf'
        if /base64/i =~ cte then
          text = NKF.nkf("-#{fromcode}e -mB", text.join).split(/(\n)/)
        elsif /quoted-printable/i =~ cte then
          text = NKF.nkf("-#{fromcode}e -mQ", text.join).split(/(\n)/)
        elsif /[78]bit/i =~ cte then
          text = NKF.nkf("-#{fromcode}e", text.join).split(/(\n)/)
        end
      end
      @text = text
      return text	# ۤޤ??
    elsif %r,multipart.*boundary=([\'\"]?)([^\'\"]+)\1,i =~ ct
      # $2 is new boundary
      text = extract_multipart($2)
      @text = text[0]
      return text
    else
    end
  end

  def rfc822header(opt)
    @header[opt]
  end
  def text()
    return @text
  end
  def debug()
    # print "text=[[[#{text}]]]---\n"
    p @body
  end

  def doStream()

    # configuration check (who is the owner)
    unless checkopt('owner') then
      debugout("Put your e-mail address into the file [#{$opt['conf']}]\n" +
	       "  #{$opt['conf']} owner=ᥤ륢ɥ쥹 äƽ񤤤ȤƤ")
    end
    unless checkopt('allow') then
      notifyto($opt['owner'], 'mkdiary-error(owner)',
	       "Put 'allow=Your@mail.address' into [#{$opt['conf']}]\n" +
	       "  #{$opt['conf']} allow=ᥤ륢ɥ쥹 äƽ񤤤ȤƤ")
    end

    # authentication
    sender = (ENV['SENDER'] || ENV['UFLINE'] ||\
    	rfc822header('Sender') || rfc822header('Return-Path')).to_s
    sender = sender.sub(/^<(.*)>$/, '\1')
    unless %r,#{$opt['allow']}, =~ sender
      notifyto($opt['owner'], 'mkdiary-illegal-access',
"allow=<<#{$opt['allow']}>>" +
	       "#{$mybase} update from #{sender}.\n" +
	       "But you don't allow #{sender} to update your diary.\n" +
	       "If you want to allow that address, write that address like\n" +
	       "\n  allow=address@foo.bar.com\n\n" +
	       "in the file #{$opt['conf']}.\n" +
	       "#{sender} 󤫤 #{$mybase} ꤬褿\n" +
	       "οͤϹͿƤʤǤ.\n" +
	       "⤷ܿͤʤ #{$opt['conf']} ե allow= Ԥ\n" +
	       "­ޤ礦ʣΥɥ쥹ϿȤ\n" +
	       'allow=yuuji@gentei.org|yuuji@hoge.hero.boo' +
	       "\nΤ褦 | Ƕڤäƽ񤭤ޤ.")
      exit 0			# via-Mail-mode should exit with 0
    end
    #
    # creation starts
    #
    eod = "<!-- end of diary -->\n"
    html = @targetdir + "/index.html"
    bak = html.sub(".html", ".bak")
    appendfile = @targetdir + "/append"
    File.umask(022)
    # mkdir @targetdir is done bye parseMessage
    #
    # parse multipart messages is also done by  parseMessage
    #
    # start parse message
    #
    line = 0
    hdr = []
    append_rest = []		# If append mode, keep rest part of file
    # Do specially when the first line matches with "merge=1"
    merged = false
    #STDERR.puts "\@text="+@text.inspect
    if @text[0] && @text[0].is_a?(Array)
      @text[0] = @text[0].join	# XXX: Meaningless?
    end
    if @text[0] && @text[0].is_a?(String) &&
        /merge=1/i =~ @text[0].toeuc &&
        test(?s, bak) && test(?s, appendfile) then
      File.unlink(html) if test(?f, html)
      File.rename(bak, html)
      @text = IO.readlines(appendfile) and File.unlink(appendfile)
      $opt['append']=1
      merged = true
    end

    while @text[line] && /(^[a-z]+)\s*=\s*(.*)$/ =~ Kconv.toeuc(@text[line])
      if $1 and isoptreadonly($1)
	notifyto($opt['owner'], 'mkdiary-illegal-challenge',
		 "WARNING: #{sender} attempted break your diary's info.\n" +
		 "#{sender} Υǡ#{$1}" +
		 "Ѥ褦Ȥޤ\n椳ȤϤǤͤ.\n")
	exit 0
      end
      $opt[$1] = $2
      $1 == "m" and $opt['mup-p'] = true
      print "opt[#{$1}] set to #{$opt[$1]}\n" if $DEBUG
      line += 1
    end
    # Process diary text
    if test(?d, @targetdir) and test(?s, html) then
      if checkopt('append') || checkopt('tasu') || checkopt('tsuika') then
	# append=yes ʤɲý. Ǥʤо
	# eod ޡޤɤ߼
	begin
	  rest = false
	  open(html, "r").each{|l|
	    if rest
	      append_rest << l	# Keep previous footer
	      next
	    end
	    if l == eod
	      rest = true
	      next
	    elsif /<div class=.footer./ =~ l
	      rest = true
	      append_rest << l
	      next
	    end
	    break if %r,</body>,i =~ l
	    hdr << l
	  }
	  $opt['mup-p'] and hdr << "<h1>#{$opt['m']}</h1>\n"
	rescue
	  notifyto($opt['owner'], 'mkdiary-append-error',
		 "You specify append=1, but not file to append.\n" +
		 "append=1 Ȼꤷ褦ɸե뤬ʤ͡\n")
	  exit 0
	end
      else			# 
	if checkopt('ownotify')
	  begin
	    if ENV['RECIPIENT']
	      ENV['QMAILUSER'], ENV['QMAILHOST'] = ENV['RECIPIENT'].split("@")
	    end
	    notifyto($opt['owner'], 'mkdiary-overwrite-backup',
		     "Here is the old diary file of the day.
դ褦äΤǥХååפ
ƤȤäȤƤ.\n
⤷Τä񤭤ǤΥХååפᤷ

  1. ¤ϤäΥᥤɲå⡼(append=1)Ĥä:
     ʸ1ܤ merge=1 Ȥ񤤤ᥤ롣
       ʲΥХååפΤˤäΥᥤɲäΤäȤޤ

  2. ¤ϤäΤϴְääХååפΤᤷ:
     ΥᥤʸѤʸƬ repl=1 Ƚ񤤤ƺ롣
       ʸϤȤ> פȤΰѵդޤޤǤ褯äơ
       ʬ򹥤ʤ褦˽ľäƤOK\n

Τɤ餫򤷤ƤۤǤ\n\n" +
		     open(html, "r").readlines.join(''))
	  rescue
	    notifyto($opt['owner'], 'mkdiary-overwrite-backup-error',
		     "Unable to backup your privious diary file of #{@date}\n"+
		     "ΥХåå׼")
	  end
	end
	File.unlink(bak) if test(?f, bak)
	File.rename(html, bak)
	open(appendfile, "w"){|a|a.print @text.join}
	hdr = @theDAY.header()
      end
    else			# 
      hdr = @theDAY.header()
    end
    open("| #{$outfilter} > #{html}", "w"){|ix|
      ix.sync = true
      if checkopt('repl') || checkopt('replace') then
	# ֤⡼
	line += 1 while /<html\b/ !~ @text[line] && line < @text.length
	if line < @text.length
	  prefix = (/^(.*)<html/ =~ @text[line] ? $1 : "")
	  # ѵäΤ񤭽Ф
	  ix.print @text[line..-1].collect{|s|s.sub(prefix, "")}.join('')
	end
      else
	hdr = hdr.join if hdr.is_a?(Array)
	ix.print hdr
	ix.print bodyfilter(Kconv.kconv(@text[line..-1].join(''), Kconv::EUC, Kconv::AUTO))
	ix.print eod
	ix.print(append_rest[0] ? append_rest.join : @theDAY.footer())
      end
    }
    if checkopt('notify') and test(?s, html) and test(?r, html) then
      notifyto($opt['owner'], 'mkdiary-update-report',
	       "ʤʤޤɡ\n\n" +
	       open(html, "r").readlines().join(''))
    end
    mkyearindex("#{$mydir}/#{@theDAY.year}")
  end

  def exportoptions()
    # export my $opt for bodyfilters
    for k, v in $opt
      ENV["opt_"+k] = v if v.is_a?(String) && v > ""
    end
  end
  def bodyfilter(text)
    return text unless checkopt('bodyfilter')
    return text if /^(none|no|nil|null|off)\b/i =~ $opt['bodyfilter']
    newcontents = []
    ENV["OUTCODE"] = $opt['outcode']
    open("|-", "r"){|rfd|
      if !rfd			# child
        open("|-", "w"){|flt|
          if !flt			# child of child
	    Dir.chdir @targetdir
	    ENV['PATH'] = ENV['PATH'] + ":#{$mydir}" # `<<' is NG
	    begin
	      exportoptions()
	      exec "/bin/sh", "-c", $opt['bodyfilter']
	    rescue
	      # if failed
	      print text
	      exit 0
	    end
	  else			# parent of child
	    #flt.sync=true	# synchronous mode
	    flt.print text
	    flt.close if RUBY_VERSION < "1.8.0"
	    exit 0
	  end
	}
      end
      newcontents = rfd.readlines
    }			# parent
    newcontents.join
  end

end

def lock()
  lockfile = "#{$mydir}/lockrb"
  timeout = 10
  open(lockfile, "w+"){|lf|
    parent = $$
    if !pid=fork then
      lf.close if RUBY_VERSION < "1.8.0"
      sleep timeout
      begin Process.kill :INT, parent rescue "" end
      exit 0
    end
    lf.flock(File::LOCK_EX)
    begin
      yield
    ensure
      lf.flock(File::LOCK_UN)
    end
  }
  File.unlink(lockfile)
end

def setup()
  STDERR.puts "¤եޤ."
  owner=''
  allow=[]
  while /.+@.+/ !~ owner
    STDERR.print "ᥤ륢ɥ쥹Ʋ: "
    owner = gets.chomp!
  end
  STDERR.puts "Ĥᥤ륢ɥ쥹Ʋ"
  STDERR.puts "󤢤1Ԥ1ĤƹԤޤ."
  STDERR.puts "ɬפʤ䡢콪ä . Ʋ."
  STDERR.puts "(Ԥꤪɤ򤪤Ƥꤿ)"
  l=''
  while true
    STDERR.printf "ĥɥ쥹%d: ", allow.length+1
    l = gets.chomp!
    case l
    when /.+@.+/
      allow << l
    when '.'
      break
    else
      STDERR.puts "ᥤ륢ɥ쥹㤦ä"
      STDERR.puts "᤿ʤ . (ԥꥪ) Ǥäƥ꥿"
    end
  end
  if owner > ''
    conffile = "#{$mydir}/.#{$mybase}rc"
    if test(?f, conffile)
      STDERR.print "#{conffile} 뤱ɾ񤭤뤱? <y/n>"
      if /^y/i !~ gets
	STDERR.puts "äȤä"
	exit
      end
    end
    open(conffile, "w") do |c|
      puts "owner=#{owner}"
      c.puts "owner=#{owner}"
      if allow.length > 0
	al = allow.collect{|l|
	  Regexp.quote(l)
	}.join("|")
	puts "allow=#{al}"
	c.puts "allow=#{al}"
      end
      # ȤϤĤ
      c.puts "# bmp2png = 0"
      c.puts "# day_ascend=0"
      c.puts "# bodyfilter=body2html|autoimg"
      c.puts "# outcode=euc"
    end
    STDERR.puts "#{conffile} ˽񤤤Ȥޤ"
  else
    STDERR.puts 'ͭԥᥤ륢ɥ쥹̵Τ'
  end
end

def mkcateg()
  Dir.chdir($mydir)
  ctg = Hash.new
  years = Hash.new(0)
  template = "category.tmpl"
  unless test(?r, $opt['categtbl'])
    STDERR.puts "No #{$opt['categtbl']}"
    return
  end
  File.foreach($opt['categtbl']) do |ct|
    ct = ct.toeuc
    next if /^\s *$|\^\s*\#/ =~ ct
    next unless /^([^:]+):\s*(.*)/ =~ ct
    k, r = $1, $2
    if %r,^/, =~ r
      re = eval r
    else
      re = Regexp.new(r)
    end
    if /(.*)=(.*)/ =~ k
      k, file = $1, $2
    else
      file = k+".html"
    end
    ctg[k] = [re, file, []]
  end
  ctg['other'] = [nil, "other.html", []]
  Dir.glob("[1-9]???/?*/?*/index.html") do |f|
    date = File.dirname(f)
    years[f.sub(%r|/.*|, "")] += 1
    text = Kconv.toeuc(open(f, "r"){|g|g.read File.size(f)})
    if (cut=(/.*<body[^>]*>/i =~ text))
      text.slice!(0..cut-1)
    end
    if (cut=text.rindex($opt['cutstr']))
      text.slice!(cut..-1)
    end
    header = daytitle(date, text)
    # p header
    found = false
    li = "<a href=\"../%s/index.html\">%s</a>" % [date, date] +" - "+header
    for k in ctg.keys
      if ctg[k][0] =~ text
	ctg[k][2] << li
	found = true
      end
    end
    found or ctg['other'][2] << li
  end
  cdir = $opt['categdir']
  other = ctg['other']
  prefix = $opt['cldprefix']
  today = DateKeeper.new
  for k in ctg.keys.sort.grep(/(?!other)/)<<'other' # make 'other' be last
    next if ctg[k][2].empty?	# Do not produce if no matchings
    test(?d, cdir) or mkdir_p(cdir)
    open("| #{$outfilter} > #{cdir}/#{ctg[k][1]}", "w") do |ch|
      printf("<a href=\"%s%s/%s\">%s</a>\n", prefix, cdir, ctg[k][1], k)
      IO.foreach(template) do |line|
        line = line.toeuc       # ruby19
	if /%LIST%/ =~ line
	  ch.print "<ol>\n"
	  for item in ctg[k][2].sort.reverse # ruby 1.6's glob doesn't sort
	    ch.printf(" <li> %s\n", item)
	  end
	  ch.print "</ol>\n"
	else
	  today.gsubkeywords(line)
	  line.gsub!(/%THEME%/, (k=='other' ? $opt['other'] :$opt['themes'])%k)
	  line.gsub!(/%KEYWORD%/, k)
	  ch.print line
	end
      end
    end
  end
  for y in years.keys.sort
    printf("<a href=\"%s%s/index.html\">%s</a>\n", prefix, y, y)
  end
end

#print day_week(2002, 1, 23) + "\n"
# print "mydir=#{$mydir}, myname=#{$myname}\n"
#print daytitle("2002/01/23")
#print monthlist("2001/05")
#p mydirname(ARGV[0])
#p checkopt(ARGV[1])
#today = DateKeeper.new("2002/01/25")
#print today.header() + "-------------\n"

while /^-.+/ =~ ($_=ARGV[0])
  $_=ARGV.shift.dup
  break if ~/^--$/
  while ~/^-[A-z]/
    case $_
    when /^-bg/
      $opt['bg'] = ARGV.shift; break
    when /^-f$/
      $opt['footer'] = ARGV.shift; break;
    when /^-date$/
      # &create(shift);
      $today = DateKeeper.new(ARGV.shift)
    when /^-today$/
      # &create_today(shift);
      $today = DateKeeper.new(today())
    when /^-c$/
      $opt['conf'] = ARGV.shift; break;
    when /^-D$/
      $DEBUG = 1
    when /^-s$/
      doStream=1; break
    when /^-setup$/
      setup; exit;
    when /^-ci$/
      $opt['categtbl'] = ARGV.shift; break;
    when /^-mkcat$/
      doCateg=1;
    else			# Skip if unknown option
      ARGV.shift; break;
    end
    $_.sub!(/^-.(.*)/, "-\\1")
  end
end

# setup $PATH
ENV['PATH'] = ENV['PATH']+':'+$opt['addpath'] if checkopt('addpath')
Initter.new
if ($today) then
  $today.create
elsif doStream
  lock{Mail.new().doStream()}
elsif doCateg
  mkcateg
elsif ARGV[0].is_a?(String) and test(?d, ARGV[0])
  ARGV.each{|dir| mkyearindex(dir)}
else
  usage()
end
