;;; -*- Emacs-Lisp -*-
;;; An interface to img2www script
;;; (c)1999 HIROSE Yuuji [yuuji@gentei.org]
;;; Last modified Sat Apr 15 11:17:45 2000 on firestorm
;;; Update count: 14

(defvar img2www:command "img2www")
(defvar img2www:tmpindex "idx--" "$BEG$-=P$7MQ$K;H$&(BINDEX$B%U%!%$%kL>(B")
(defvar img2www:begin nil "$BA^F~0LCV(B")
(defvar img2www:end nil "$BCV49;~$N=*N;0LCV(B")
(defvar img2www:default-background "white" "$B%G%U%)%k%H$N(Bbgcolor")
(defvar img2www:default-option "" "bg$B%+%i!<0J30$N%G%U%)%k%H%*%W%7%g%s(B")
(defvar img2www:current-buffer nil "$B=hM}$r5/F0$7$?%P%C%U%!(B")

(defun img2www*filter (proc mes)
  "$B%W%m%;%9%U%#%k%?(B"
  (if (and (stringp mes)
	   (string-match "mini=\\([^,]+\\)," mes))
      (let ((base (substring mes (match-beginning 1) (match-end 1))))
	(message "$B=hM}Cf(B: %s" base))))

(defun img2www*sentinel (proc state)
  "$B=*N;DLCN(B"
  (cond ((string-match "^finished" state)
	 (set-buffer img2www:current-buffer)
	 (save-excursion
	   (goto-char img2www:begin)
	   (if img2www:end (delete-region (point) img2www:end))
	   (insert-file-contents img2www:tmpindex nil 1)
	   (delete-file img2www:tmpindex)
	   (set-marker img2www:begin nil)
	   (if img2www:end (set-marker img2www:end nil))
	   (message "Done.")))))

(defun img2www*current-bg ()
  (save-excursion
    (goto-char (point-min))
    (if (re-search-forward
	 "bgcolor\\s *=\\s *\\(\"?\\)\\([A-Za-z#0-9]+\\)\\(\\1?\\)" nil t)
	(buffer-substring (match-beginning 2) (match-end 2))
      img2www:default-background)))

(defun img2www (arg)
  "$B%]%$%s%H0LCV$K(Bimg2www$B$+$i$N(BHTML$B$rA^F~!#(B
\\[universal-argument] $B$rIU$1$k$H8=:_$N%j%8%g%s$r(Bimg2www$B=PNO$GCV49(B"
  (interactive "P")
  (if arg
      (setq img2www:begin (copy-marker (region-beginning))
	    img2www:end (copy-marker (region-end)))
    (setq img2www:begin (point-marker)
	  img2www:end nil))
  (setq img2www:current-buffer (current-buffer))
  (let ((buf (get-buffer-create " *img2wwwtmp*"))
	(bg (img2www*current-bg))
	other str jpgs (dir default-directory))
    (setq other (read-string "img2www $B$N%*%W%7%g%s(B: "
			     (concat "-bg " bg " " img2www:default-option)))
    (setq jpgs (read-string "$B=hM}BP>](B: " "*jpg"))
    (save-excursion
      (find-file img2www:tmpindex)
      (setq buffer-read-only nil)
      (erase-buffer)
      (insert "\n")
      (basic-save-buffer)
      (kill-buffer nil))
    (set-buffer buf)
    (cd dir) (setq default-directory dir)
    (setq buffer-read-only nil)
    (erase-buffer)
    (setq str (concat img2www:command " -ix " img2www:tmpindex " " other
		      " " jpgs))
    (set-process-filter
     (start-process
      "img2www" (current-buffer)
      shell-file-name shell-command-switch str)
     'img2www*filter)
    (set-process-sentinel
     (get-buffer-process (current-buffer)) 'img2www*sentinel)
    (message "Staring [%s]" str)))


(provide 'img2www)
